<?php
/**
 * Plugin Name: KoorTickets Block
 * Plugin URI:  https://koortickets.nl
 * Description: Een WordPress block voor de KoorTickets ticketshop.
 * Version:     1.0.0
 * Author:      KoorTickets
 * Author URI:  https://koortickets.nl
 * License:     GPL2+
 * Text Domain: koortickets-block
 */



if (!defined('ABSPATH')) exit;

function koortickets_block_init() {
    // Registreer editor JS
    wp_register_script(
        'koortickets-block-editor',
        plugins_url('build/index.js', __FILE__),
        array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components'),
        filemtime(plugin_dir_path(__FILE__) . 'build/index.js')
    );

    // Registreer CSS
    wp_register_style(
        'koortickets-block-style',
        plugins_url('build/style.css', __FILE__),
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'build/style.css')
    );

    // Registreer block
    // register_block_type('koortickets/ticketshop', array(
    //     'editor_script' => 'koortickets-block-editor',
    //     'style' => 'koortickets-block-style',
    //     'render_callback' => function($attributes) {
    //         // Bouw de URL voor frontend iframe
    //         $url = 'https://koortickets.nl/shop.php?embed';
    //         if (!empty($attributes['ids'])) $url .= '&ids=' . urlencode($attributes['ids']);

    //         // Colors
    //         if (!empty($attributes['colors']) && is_array($attributes['colors'])) {
    //             foreach ($attributes['colors'] as $key => $val) {
    //                 if ($val !== '') $url .= "&{$key}color=" . urlencode($val);
    //             }
    //         }

    //         // Visibility toggles
    //         if (!empty($attributes['visibility']) && is_array($attributes['visibility'])) {
    //             foreach ($attributes['visibility'] as $key => $val) {
    //                 if ($val) $url .= "&{$key}";
    //             }
    //         }

    //         // FontSizes
    //         if (!empty($attributes['fontSizes']) && is_array($attributes['fontSizes'])) {
    //             foreach ($attributes['fontSizes'] as $key => $val) {
    //                 if ($val !== '') $url .= "&fontsizefor_{$key}=" . urlencode($val);
    //             }
    //         }

    //         // Spacing
    //         if (!empty($attributes['spacing']) && is_array($attributes['spacing'])) {
    //             foreach ($attributes['spacing'] as $key => $val) {
    //                 if ($val !== '') $url .= "&spacingfor_{$key}=" . urlencode($val);
    //             }
    //         }

    //         // Font
    //         if (!empty($attributes['font'])) $url .= '&font=' . urlencode($attributes['font']);

    //         // Inputmode
    //         if (!empty($attributes['inputmode']) && $attributes['inputmode'] === 'radio') {
    //             $url .= '&useradio';
    //         }

    //         $width = !empty($attributes['width']) ? $attributes['width'] : '100%';
    //         $height = !empty($attributes['height']) ? $attributes['height'] : '600px';
    //         $align = !empty($attributes['alignment']) ? $attributes['alignment'] : 'center';

    //         return "<div style='text-align:{$align};'>
    //                     <iframe src='{$url}' style='width:{$width};height:{$height};border:0;'></iframe>
    //                 </div>";
    //     }
    // ));

    
    register_block_type('koortickets/ticketshop', array(
        'editor_script' => 'koortickets-block-editor',
        'style' => 'koortickets-block-style',
        'render_callback' => function($attributes) {
            $url = 'https://koortickets.nl/ticketshop.php?embed';
    
            // IDs
            if (!empty($attributes['ids'])) {
                $url .= '&ids=' . urlencode($attributes['ids']);
            }
    
            // Colors
            if (!empty($attributes['colors']) && is_array($attributes['colors'])) {
                foreach ($attributes['colors'] as $key => $val) {
                    if ($val !== '') {
                        $url .= "&{$key}color=" . urlencode($val);
                    }
                }
            }
    
            // Visibility
            if (!empty($attributes['visibility']) && is_array($attributes['visibility'])) {
                foreach ($attributes['visibility'] as $key => $val) {
                    if ($val) {
                        $url .= "&{$key}";
                    }
                }
            }
    
            // FontSizes
            if (!empty($attributes['fontSizes']) && is_array($attributes['fontSizes'])) {
                foreach ($attributes['fontSizes'] as $key => $val) {
                    if ($val !== '') {
                        $url .= "&fontsizefor_{$key}=" . urlencode($val);
                    }
                }
            }
    
            // Spacing
            if (!empty($attributes['spacing']) && is_array($attributes['spacing'])) {
                foreach ($attributes['spacing'] as $key => $val) {
                    if ($val !== '') {
                        $url .= "&spacingfor_{$key}=" . urlencode($val);
                    }
                }
            }
    
            // Font
            if (!empty($attributes['font'])) {
                $url .= '&font=' . urlencode($attributes['font']);
            }
    
            // Inputmode
            if (!empty($attributes['inputmode']) && $attributes['inputmode'] === 'radio') {
                $url .= '&useradio';
            }
    
            // Language
            if (!empty($attributes['language'])) {
                $url .= '&' . urlencode($attributes['language']);
            }
    
            // Width / Height / Alignment
            $width  = !empty($attributes['width']) ? $attributes['width'] : '100%';
            $height = !empty($attributes['height']) ? $attributes['height'] : '600px';
            $align  = !empty($attributes['alignment']) ? $attributes['alignment'] : 'center';
    
            // Output iframe
            return "<div style='text-align:{$align};'>
                        <iframe src='{$url}' style='width:{$width};height:{$height};border:0;'></iframe>
                    </div>";
        }
    ));
        
    
    
}

add_action('init', 'koortickets_block_init');

